unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, INIFiles, Form3D, ExtCtrls;

type
  TForm1 = class(TForm3D)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Label1: TLabel;
    Button4: TButton;
    Label2: TLabel;
    OpenDialog1: TOpenDialog;
    Image1: TImage;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Bevel1: TBevel;
    procedure Button1Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
 Close;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
 with OpenDialog1 do
  begin
   if execute then
    if filename <> '' then begin
    Button2.Enabled:=True;
    Button3.Enabled:=True;
    Label1.Caption:=Filename;
    end;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
var CurrentShell : string;
begin
 image1.picture.graphic := application.icon;
 with TINIFile.Create('SYSTEM.INI') do
  try
   CurrentShell:=ReadString('Boot', 'Shell', 'ERROR');
   Label1.Caption := UpperCase(CurrentShell);
  finally free;
  end;
end;

procedure TForm1.Button3Click(Sender: TObject);
var NewShell : string;
begin
 NewShell := Label1.Caption;
 with TINIFile.Create('SYSTEM.INI') do
  try
   WriteString('Boot', 'Shell', NewShell);
  finally free;
 end;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
 Button3Click(Sender);
 ExitWindows(66,0);
end;

end.